/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.block.entity;

import net.conczin.immersive_furniture.block.entity.BlockEntityTypes;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3917;

public class FurnitureBlockEntity
extends class_2586
implements class_1263,
class_3908 {
    private String hash;
    private FurnitureData data;
    private final class_2371<class_1799> items = class_2371.method_10213((int)81, (Object)class_1799.field_8037);

    public FurnitureBlockEntity(class_2338 pos, class_2680 blockState) {
        super(BlockEntityTypes.FURNITURE, pos, blockState);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.items.clear();
        class_1262.method_5429((class_2487)tag, this.items);
        if (tag.method_10545("Furniture")) {
            this.data = new FurnitureData(tag.method_10562("Furniture"));
        } else if (tag.method_10545("FurnitureHash")) {
            this.hash = tag.method_10558("FurnitureHash");
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.items);
        if (this.data != null) {
            if (Config.getInstance().saveAsHash) {
                FurnitureDataManager.saveHashData(this.data);
                tag.method_10582("FurnitureHash", this.data.getHash());
            } else {
                tag.method_10566("Furniture", (class_2520)this.data.toTag());
            }
        } else if (this.hash != null) {
            tag.method_10582("FurnitureHash", this.hash);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public FurnitureData getData() {
        if (this.hash != null) {
            this.data = this.field_11863 != null && this.field_11863.field_9236 ? FurnitureDataManager.getCachedData(this.hash) : FurnitureDataManager.getData(this.hash);
            if (this.data != null) {
                this.hash = null;
            }
        }
        return this.data;
    }

    public int method_5439() {
        FurnitureData furnitureData = this.getData();
        if (furnitureData == null) {
            return 0;
        }
        return furnitureData.inventorySize * 9;
    }

    public void method_5448() {
        this.getItems().clear();
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.getItems()) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.getItems().get(slot);
    }

    public void method_5431() {
        FurnitureData data;
        super.method_5431();
        if (this.field_11863 != null && (data = this.getData()) != null && data.hasDisplayItems()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.getItems(), (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.getItems(), (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.getItems().set(slot, (Object)stack);
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public class_2561 method_5476() {
        FurnitureData d = this.getData();
        return d == null ? class_2561.method_43471((String)"gui.immersive_furniture.furniture") : class_2561.method_43470((String)d.name);
    }

    public class_1703 createMenu(int containerId, class_1661 inventory, class_1657 player) {
        FurnitureData data = this.getData();
        if (data == null) {
            return null;
        }
        int rows = data.inventorySize;
        if (rows == 0) {
            return null;
        }
        class_3917 menuType = switch (rows) {
            case 6 -> class_3917.field_17327;
            case 5 -> class_3917.field_18667;
            case 4 -> class_3917.field_18666;
            case 3 -> class_3917.field_17326;
            case 2 -> class_3917.field_18665;
            default -> class_3917.field_18664;
        };
        return new class_1707(menuType, containerId, inventory, (class_1263)this, rows);
    }

    public void method_5435(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.playSound(class_3417.field_17604);
        }
    }

    public void method_5432(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.playSound(class_3417.field_17603);
        }
    }

    void playSound(class_3414 sound) {
        if (this.field_11863 == null) {
            return;
        }
        double d = (double)this.field_11867.method_10263() + 0.5;
        double e = (double)this.field_11867.method_10264() + 0.5;
        double f = (double)this.field_11867.method_10260() + 0.5;
        this.field_11863.method_43128(null, d, e, f, sound, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
    }

    public void method_11012() {
        super.method_11012();
    }
}

