/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.Utils;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationLibraryScreen;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationScreen;
import net.conczin.immersive_furniture.client.gui.components.EffectsComponent;
import net.conczin.immersive_furniture.client.gui.components.MaterialsComponent;
import net.conczin.immersive_furniture.client.gui.components.ModelComponent;
import net.conczin.immersive_furniture.client.gui.components.ParticlesComponent;
import net.conczin.immersive_furniture.client.gui.components.SettingsComponent;
import net.conczin.immersive_furniture.client.gui.components.SoundsComponent;
import net.conczin.immersive_furniture.client.gui.components.SpritesComponent;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.client.model.ClientModelUtils;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.data.ModelUtils;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import net.minecraft.class_7919;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ArtisansWorkstationEditorScreen
extends ArtisansWorkstationScreen {
    public static final class_2960 TEXTURE_CHECKERPLANE = Common.locate("textures/gui/checkerplane.png");
    public static final int TOOLS_WIDTH = 100;
    float camYaw = -2.3561945f;
    float camPitch = -0.7853982f;
    float camZoom = 100.0f;
    public FurnitureData data;
    public List<FurnitureData.Element> selectedElements = new LinkedList<FurnitureData.Element>();
    public HoverResult hoverResult;
    static final int MAX_HISTORY_SIZE = 20;
    private String lastHistoryHash = "";
    private final Deque<class_2487> history = new ArrayDeque<class_2487>(20);
    private List<class_2487> copiedElements = new LinkedList<class_2487>();
    private long lastAutosaveTime = 0L;
    DraggingContext draggingContext;
    boolean isRotatingView;
    int lastMouseX;
    int lastMouseY;
    int elementShift = 0;
    final MaterialsComponent materialsComponent = new MaterialsComponent(this);
    final ParticlesComponent particlesComponent = new ParticlesComponent(this);
    final SoundsComponent poundsComponent = new SoundsComponent(this);
    final ModelComponent modelComponent = new ModelComponent(this);
    final EffectsComponent effectsComponent = new EffectsComponent(this);
    final SettingsComponent settingsComponent = new SettingsComponent(this);
    final SpritesComponent spritesComponent = new SpritesComponent(this);
    Page currentPage = Page.MODEL;
    boolean backwardsCheckerPlane = true;

    public ArtisansWorkstationEditorScreen(FurnitureData data) {
        this.data = data;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.method_37067();
        this.field_22787 = class_310.method_1551();
        switch (this.currentPage) {
            case MODEL: {
                this.modelComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
                break;
            }
            case MATERIALS: {
                this.materialsComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
                break;
            }
            case PARTICLES: {
                this.particlesComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
                break;
            }
            case SOUNDS: {
                this.poundsComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
                break;
            }
            case EFFECTS: {
                this.effectsComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
                break;
            }
            case SETTINGS: {
                this.settingsComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
                break;
            }
            case SPRITES: {
                this.spritesComponent.init(this.leftPos, this.topPos, 100, this.windowHeight);
            }
        }
        class_5250 text = class_2561.method_43471((String)"gui.immersive_furniture.tab.cancel");
        StateImageButton button = new StateImageButton(this.leftPos + 4, this.topPos - 24, 26, 28, 130, 56, TEXTURE, 256, 256, b -> this.cancel(), (class_2561)text);
        button.method_47400(class_7919.method_47407((class_2561)text));
        button.setEnabled(false);
        this.method_37063(button);
        int x = 16;
        this.method_37063(this.pagePageButton(Page.MODEL, x, 0));
        x += 26;
        if (this.isFirstElement(FurnitureData.ElementType.PARTICLE_EMITTER)) {
            this.method_37063(this.pagePageButton(Page.PARTICLES, x, 156));
            x += 26;
        } else if (this.isFirstElement(FurnitureData.ElementType.SOUND_EMITTER)) {
            this.method_37063(this.pagePageButton(Page.SOUNDS, x, 182));
            x += 26;
        } else if (this.isFirstElement(FurnitureData.ElementType.ELEMENT)) {
            this.method_37063(this.pagePageButton(Page.MATERIALS, x, 26));
            this.method_37063(this.pagePageButton(Page.EFFECTS, x += 26, 52));
            x += 26;
        } else if (this.isFirstElement(FurnitureData.ElementType.SPRITE) && this.getFirstElement().filter(e -> !e.sprite.item).isPresent()) {
            this.method_37063(this.pagePageButton(Page.SPRITES, x, 104));
            this.method_37063(this.pagePageButton(Page.EFFECTS, x += 26, 52));
            x += 26;
        }
        this.method_37063(this.pagePageButton(Page.SETTINGS, x, 78));
        class_5250 helpText = class_2561.method_43471((String)"gui.immersive_furniture.tab.help");
        StateImageButton helpButton = new StateImageButton(this.leftPos + 240, this.topPos - 24, 26, 28, 208, 56, TEXTURE, 256, 256, b -> this.openHelp(), (class_2561)helpText);
        helpButton.setEnabled(false);
        helpButton.method_47400(class_7919.method_47407((class_2561)helpText));
        this.method_37063(helpButton);
        this.sideButton(this.nightMode ? "gui.immersive_furniture.nightmode" : "gui.immersive_furniture.daymode", this.topPos + this.windowHeight - 19, 208, 160, this.nightMode, b -> {
            this.nightMode = !this.nightMode;
            this.method_25426();
        });
        this.sideButton("gui.immersive_furniture.backwards_checkerplane", this.topPos + this.windowHeight - 36, 224, 160, this.backwardsCheckerPlane, b -> {
            this.backwardsCheckerPlane = !this.backwardsCheckerPlane;
            this.method_25426();
        });
        this.sideButton("gui.immersive_furniture.current_state", this.topPos + this.windowHeight - 53, 208 + this.currentState * 16, 224, false, b -> {
            this.currentState = this.currentState == 0 ? 1 : 0;
            this.method_25426();
        });
        this.addHistory();
    }

    private void sideButton(String tooltip, int y, int u, int v, boolean enabled, class_4185.class_4241 action) {
        class_5250 text = class_2561.method_43471((String)tooltip);
        StateImageButton state = new StateImageButton(this.leftPos + this.windowWidth + 1, y, 16, 16, u, v, TEXTURE, 256, 256, action, (class_2561)text);
        state.method_47400(class_7919.method_47407((class_2561)text));
        state.setEnabled(enabled);
        this.method_37063(state);
    }

    private void cancel() {
        if (this.lastCriticalActionAttempt + 5000L > System.currentTimeMillis()) {
            class_310.method_1551().method_1507((class_437)new ArtisansWorkstationLibraryScreen());
        } else {
            this.lastCriticalActionAttempt = System.currentTimeMillis();
            this.setError("gui.immersive_furniture.cancel_confirm");
        }
    }

    private StateImageButton pagePageButton(Page page, int x, int u) {
        class_5250 text = class_2561.method_43471((String)("gui.immersive_furniture.tab." + page.name().toLowerCase(Locale.ROOT)));
        StateImageButton button = new StateImageButton(100 + (this.windowWidth - 100 - 26 * Page.values().length) / 2 + this.leftPos + x, this.topPos - 24, 26, 28, u, 56, TEXTURE, 256, 256, b -> {
            this.currentPage = page;
            this.method_25426();
        }, (class_2561)text);
        button.method_47400(class_7919.method_47407((class_2561)text));
        button.setEnabled(this.currentPage == page);
        return button;
    }

    private void openHelp() {
        try {
            class_156.method_668().method_670("https://github.com/Luke100000/immersiveFurniture/wiki/Help");
        }
        catch (Exception e) {
            Common.logger.error((Object)e);
        }
    }

    public void method_25420(class_332 graphics) {
        super.method_25420(graphics);
        this.drawRectangle(graphics, this.leftPos, this.topPos, 100, this.windowHeight);
        this.drawRectangle(graphics, this.leftPos + 100, this.topPos, this.windowWidth - 100, this.windowHeight);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.data.dirty();
        graphics.method_44379(this.leftPos + 100 + 3, this.topPos + 3, this.leftPos + this.windowWidth - 3, this.topPos + this.windowHeight - 3);
        this.drawModel(graphics, this.data, this.leftPos + 100 + (this.windowWidth - 100) / 2, this.topPos + this.windowHeight / 2, this.camZoom, this.camYaw, this.camPitch, mouseX, mouseY);
        graphics.method_44380();
        graphics.method_51448().method_46416(0.0f, 0.0f, 2048.0f);
        switch (this.currentPage) {
            case MODEL: {
                this.modelComponent.render(graphics);
                break;
            }
            case MATERIALS: {
                this.materialsComponent.render(graphics);
                break;
            }
            case PARTICLES: {
                this.particlesComponent.render(graphics);
                break;
            }
            case SOUNDS: {
                this.poundsComponent.render(graphics);
                break;
            }
            case SETTINGS: {
                this.settingsComponent.render(graphics);
                break;
            }
            case SPRITES: {
                this.spritesComponent.render(graphics);
            }
        }
        this.renderError(graphics, this.field_22790 / 2);
    }

    public Vector3f quantVector(Vector3f normal, float offset, boolean quantize) {
        normal.mul(offset);
        float stepSize = quantize ? 4.0f : 1.0f;
        normal.x = (float)Math.floor(normal.x * stepSize + 0.5f) / stepSize;
        normal.y = (float)Math.floor(normal.y * stepSize + 0.5f) / stepSize;
        normal.z = (float)Math.floor(normal.z * stepSize + 0.5f) / stepSize;
        return normal;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isRotatingView) {
            this.camYaw += (float)(dragX * (double)0.015f);
            this.camPitch -= (float)(dragY * (double)0.015f);
        }
        if (this.draggingContext != null) {
            Vector3f normal2;
            Vector3f normal;
            float offset = this.draggingContext.getOffset(mouseX, mouseY);
            Vector3f local = this.quantVector(this.draggingContext.direction.method_23955(), offset, false);
            Vector3f global = this.quantVector(this.draggingContext.getNormal(), offset, ArtisansWorkstationEditorScreen.method_25441() && !this.draggingContext.resize);
            if (this.draggingContext.resize) {
                if (ArtisansWorkstationEditorScreen.method_25442()) {
                    normal = new Vector3f((Vector3fc)local);
                    normal2 = local.negate();
                } else {
                    Vector3f o = new Vector3f((Vector3fc)local).sub((Vector3fc)global).mul(0.5f);
                    normal = new Vector3f((Vector3fc)local).sub((Vector3fc)o);
                    normal2 = new Vector3f(0.0f).sub((Vector3fc)o);
                }
            } else {
                normal = global;
                normal2 = global;
            }
            Vector3f fNormal = new Vector3f((Vector3fc)normal);
            Vector3f fNormal2 = new Vector3f((Vector3fc)normal2);
            ModelUtils.rotate(fNormal, this.draggingContext.element.axis, -this.draggingContext.element.rotation);
            ModelUtils.rotate(fNormal, this.draggingContext.element.axis, this.draggingContext.element.rotation);
            ModelUtils.rotate(fNormal2, this.draggingContext.element.axis, -this.draggingContext.element.rotation);
            ModelUtils.rotate(fNormal2, this.draggingContext.element.axis, this.draggingContext.element.rotation);
            for (FurnitureData.Element element : this.selectedElements) {
                if (!this.draggingContext.originalFrom.containsKey(element)) continue;
                Vector3f originalFrom = this.draggingContext.originalFrom.get(element);
                Vector3f originalTo = this.draggingContext.originalTo.get(element);
                if (this.draggingContext.direction == class_2350.field_11033 || this.draggingContext.direction == class_2350.field_11039 || this.draggingContext.direction == class_2350.field_11043) {
                    element.from.x = Math.min(element.to.x, originalFrom.x + fNormal.x);
                    element.from.y = Math.min(element.to.y, originalFrom.y + fNormal.y);
                    element.from.z = Math.min(element.to.z, originalFrom.z + fNormal.z);
                    element.to.x = Math.max(element.from.x, originalTo.x + fNormal2.x);
                    element.to.y = Math.max(element.from.y, originalTo.y + fNormal2.y);
                    element.to.z = Math.max(element.from.z, originalTo.z + fNormal2.z);
                } else {
                    element.to.x = Math.max(element.from.x, originalTo.x + fNormal.x);
                    element.to.y = Math.max(element.from.y, originalTo.y + fNormal.y);
                    element.to.z = Math.max(element.from.z, originalTo.z + fNormal.z);
                    element.from.x = Math.min(element.to.x, originalFrom.x + fNormal2.x);
                    element.from.y = Math.min(element.to.y, originalFrom.y + fNormal2.y);
                    element.from.z = Math.min(element.to.z, originalFrom.z + fNormal2.z);
                }
                element.sanityCheck();
            }
            if (this.currentPage == Page.MODEL) {
                this.modelComponent.update();
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if ((button == 0 || button == 1) && this.hoverResult != null) {
            boolean doubleClick;
            boolean bl = doubleClick = this.lastMouseX == (int)mouseX && this.lastMouseY == (int)mouseY;
            if (button == 0 && ArtisansWorkstationEditorScreen.method_25442() && this.selectedElements.contains(this.hoverResult.element)) {
                this.selectedElements.remove(this.hoverResult.element);
            } else {
                this.selectElement(this.hoverResult.element(), ArtisansWorkstationEditorScreen.method_25442() || this.selectedElements.size() > 1 && !doubleClick);
            }
            if (this.currentPage == Page.MATERIALS || this.currentPage == Page.SOUNDS || this.currentPage == Page.PARTICLES || this.currentPage == Page.SPRITES) {
                if (this.isFirstElement(FurnitureData.ElementType.ELEMENT)) {
                    this.currentPage = Page.MATERIALS;
                } else if (this.isFirstElement(FurnitureData.ElementType.SOUND_EMITTER)) {
                    this.currentPage = Page.SOUNDS;
                } else if (this.isFirstElement(FurnitureData.ElementType.PARTICLE_EMITTER)) {
                    this.currentPage = Page.PARTICLES;
                } else if (this.isFirstElement(FurnitureData.ElementType.SPRITE)) {
                    this.currentPage = Page.SPRITES;
                }
            }
            this.draggingContext = new DraggingContext(this.hoverResult.element(), this.hoverResult.direction(), mouseX, mouseY, button == 1);
            this.isRotatingView = false;
            this.method_25426();
        } else {
            this.isRotatingView = this.isOverRightWindow(mouseX, mouseY);
        }
        this.lastMouseX = (int)mouseX;
        this.lastMouseY = (int)mouseY;
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.draggingContext != null) {
            this.draggingContext = null;
        }
        if (!this.selectedElements.isEmpty() && this.hoverResult == null && this.lastMouseX == (int)mouseX && this.lastMouseY == (int)mouseY && this.isOverRightWindow(mouseX, mouseY)) {
            this.selectedElements.clear();
            this.method_25426();
        }
        this.addHistory();
        return super.method_25406(mouseX, mouseY, button);
    }

    private boolean isOverRightWindow(double mouseX, double mouseY) {
        return mouseX > (double)(this.leftPos + 100) && mouseX < (double)(this.leftPos + this.windowWidth) && mouseY > (double)this.topPos && mouseY < (double)(this.topPos + this.windowHeight);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (ArtisansWorkstationEditorScreen.method_25438((int)keyCode)) {
            this.copiedElements = this.selectedElements.stream().map(FurnitureData.Element::toTag).toList();
        } else if (ArtisansWorkstationEditorScreen.method_25436((int)keyCode)) {
            if (!this.selectedElements.isEmpty()) {
                this.copiedElements = this.selectedElements.stream().map(FurnitureData.Element::toTag).toList();
                this.data.elements.removeAll(this.selectedElements);
                this.selectedElements.clear();
                this.method_25426();
            }
        } else if (ArtisansWorkstationEditorScreen.method_25437((int)keyCode)) {
            if (!this.copiedElements.isEmpty()) {
                this.selectedElements.clear();
                for (class_2487 copiedElement : this.copiedElements) {
                    FurnitureData.Element element = new FurnitureData.Element(copiedElement);
                    this.data.elements.add(element);
                    this.selectedElements.add(element);
                }
                this.method_25426();
            }
        } else if (keyCode == 261) {
            if (!this.selectedElements.isEmpty() && this.isOverRightWindow(this.lastMouseX, this.lastMouseY)) {
                this.data.elements.removeAll(this.selectedElements);
                this.selectedElements.clear();
                this.method_25426();
            }
        } else if (keyCode == 68 && ArtisansWorkstationEditorScreen.method_25441() && !ArtisansWorkstationEditorScreen.method_25442() && !ArtisansWorkstationEditorScreen.method_25443()) {
            this.modelComponent.duplicateElements();
        } else if (keyCode == 65 && ArtisansWorkstationEditorScreen.method_25441() && !ArtisansWorkstationEditorScreen.method_25442() && !ArtisansWorkstationEditorScreen.method_25443()) {
            this.selectedElements.clear();
            this.selectedElements.addAll(this.data.elements);
            this.method_25426();
        } else if (keyCode == 77 && ArtisansWorkstationEditorScreen.method_25441() && !ArtisansWorkstationEditorScreen.method_25442() && !ArtisansWorkstationEditorScreen.method_25443()) {
            if (!this.selectedElements.isEmpty() && !this.copiedElements.isEmpty()) {
                FurnitureData.Element element = new FurnitureData.Element(this.copiedElements.get(0));
                for (FurnitureData.Element selectedElement : this.selectedElements) {
                    selectedElement.material = new FurnitureData.Material(element.material);
                    selectedElement.color = element.color;
                    selectedElement.emission = element.emission;
                }
                this.method_25426();
            }
        } else if (ArtisansWorkstationEditorScreen.isUndo(keyCode)) {
            class_2487 oldData;
            if (!this.history.isEmpty() && this.lastHistoryHash.equals(this.data.getHash())) {
                this.history.removeFirst();
            }
            if (!this.history.isEmpty() && (oldData = this.history.removeFirst()) != null) {
                this.data = new FurnitureData(oldData);
                this.selectedElements.clear();
                this.method_25426();
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public static boolean isUndo(int keyCode) {
        return (keyCode == 89 || keyCode == 90) && ArtisansWorkstationEditorScreen.method_25441() && !ArtisansWorkstationEditorScreen.method_25442() && !ArtisansWorkstationEditorScreen.method_25443();
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (ArtisansWorkstationEditorScreen.method_25442()) {
            this.elementShift += mouseY > 0.0 ? 1 : -1;
        } else {
            this.camZoom = Math.max(20.0f, Math.min(120.0f, this.camZoom + (float)delta * 0.1f * this.camZoom));
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        this.elementShift = 0;
    }

    protected void drawModel(class_332 graphics, FurnitureData data, int x, int y, float size, float yaw, float pitch, int mouseX, int mouseY) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904((double)x, (double)y, 1024.0);
        graphics.method_51448().method_34425(new Matrix4f().scaling(size));
        graphics.method_51448().method_22907(new Quaternionf().rotateX(pitch).rotateY(yaw));
        graphics.method_51448().method_46416((float)(-data.size.x) / 2.0f, (float)data.size.y / 2.0f, (float)(-data.size.z) / 2.0f);
        graphics.method_51448().method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        class_308.method_27869((Matrix4f)new Matrix4f().rotateX(pitch).rotateY(yaw));
        this.renderModel(graphics, data, yaw, pitch, true);
        class_308.method_24211();
        graphics.method_51448().method_22903();
        this.checkerPlane(graphics, data.size.x, data.size.z);
        graphics.method_51448().method_22907(new Quaternionf().rotateX(1.5707964f));
        graphics.method_51448().method_46416(0.0f, (float)data.size.z, 0.0f);
        graphics.method_51448().method_22905(1.0f, 1.0f, -1.0f);
        if (this.backwardsCheckerPlane) {
            this.checkerPlane(graphics, data.size.x, data.size.y);
        }
        graphics.method_51448().method_22909();
        Matrix4f pose = graphics.method_51448().method_23760().method_23761();
        graphics.method_51448().method_22909();
        LinkedList<HoverResult> results = new LinkedList<HoverResult>();
        for (FurnitureData.Element element : data.elements) {
            Utils.Ray ray;
            Utils.RaycastResult raycastResult;
            if (!element.isMasked(this.currentState) || (raycastResult = Utils.raycast(ray = Utils.inverseTransformRay(mouseX, mouseY, pose, element), element)) == null) continue;
            results.add(new HoverResult(element, raycastResult.face(), raycastResult.distance()));
        }
        if (results.isEmpty() || !this.isOverRightWindow(mouseX, mouseY)) {
            this.hoverResult = null;
        } else {
            results.sort((a, b) -> Float.compare(b.depth, a.depth));
            int index = 0;
            if (!(this.selectedElements.isEmpty() || ArtisansWorkstationEditorScreen.method_25442() && this.selectedElements.size() > 1)) {
                for (int i = 0; i < results.size(); ++i) {
                    if (!this.selectedElements.contains(((HoverResult)results.get(i)).element())) continue;
                    index = i;
                    break;
                }
            }
            this.hoverResult = (HoverResult)results.get((index + this.elementShift) % results.size());
            float selectionWidth = this.selectedElements.contains(this.hoverResult.element()) ? 1.25f : 1.0f;
            this.drawSelection(graphics, this.hoverResult.element(), pose, selectionWidth, false);
        }
        graphics.method_51452();
        for (FurnitureData.Element selectedElement : this.selectedElements) {
            this.drawSelection(graphics, selectedElement, pose, 0.6f, true);
        }
        for (FurnitureData.Element element : data.elements) {
            if (!element.isMasked(this.currentState) || element.type == FurnitureData.ElementType.ELEMENT || element.type == FurnitureData.ElementType.SPRITE) continue;
            this.drawSelection(graphics, element, pose, 0.4f, true);
        }
    }

    void checkerPlane(class_332 graphics, float w, float h) {
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE_CHECKERPLANE);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        builder.method_22918(matrix4f, 0.0f, 0.001f, 0.0f).method_22913(0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 0.5f).method_1344();
        builder.method_22918(matrix4f, 0.0f, 0.001f, h).method_22913(0.0f, h / 8.0f).method_22915(1.0f, 1.0f, 1.0f, 0.5f).method_1344();
        builder.method_22918(matrix4f, w, 0.001f, h).method_22913(w / 8.0f, h / 8.0f).method_22915(1.0f, 1.0f, 1.0f, 0.5f).method_1344();
        builder.method_22918(matrix4f, w, 0.001f, 0.0f).method_22913(w / 8.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 0.5f).method_1344();
        class_286.method_43433((class_287.class_7433)builder.method_1326());
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
    }

    void drawSelection(class_332 graphics, FurnitureData.Element element, Matrix4f pose, float width, boolean overlay) {
        float[] fs = ClientModelUtils.getShapeData(element);
        for (class_2350 facing : class_2350.values()) {
            Vector3f[] vertices = ClientModelUtils.getVertices(element, facing, fs, pose);
            for (int i = 0; i < 4; ++i) {
                Vector3f vertex = vertices[i];
                Vector3f nextVertex = vertices[(i + 1) % 4];
                float adjustedWidth = element.type == FurnitureData.ElementType.PLAYER_POSE && facing == class_2350.field_11043 ? 1.5f + width * 0.5f : width;
                this.line(graphics, vertex.x(), vertex.y(), vertex.z(), nextVertex.x(), nextVertex.y(), nextVertex.z(), adjustedWidth, overlay, 0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    public boolean method_25422() {
        return false;
    }

    public void addHistory() {
        String hash = this.data.getHash();
        if (!this.lastHistoryHash.equals(hash)) {
            long currentTime;
            this.lastHistoryHash = hash;
            if (this.history.size() >= 20) {
                this.history.removeLast();
            }
            this.history.addFirst(this.data.toTag());
            int autosaveInterval = Config.getInstance().autosaveInterval;
            if (autosaveInterval >= 0 && (currentTime = System.currentTimeMillis()) - this.lastAutosaveTime > (long)autosaveInterval * 1000L) {
                FurnitureDataManager.save(this.data, new class_2960("local", "autosave"));
                this.lastAutosaveTime = currentTime;
            }
        }
    }

    public Optional<FurnitureData.Element> getFirstElement() {
        return this.selectedElements.isEmpty() ? Optional.empty() : Optional.of(this.selectedElements.get(0));
    }

    public boolean isFirstElement(FurnitureData.ElementType type) {
        return this.getFirstElement().filter(e -> e.type == type).isPresent();
    }

    public void selectElement(FurnitureData.Element element, boolean add) {
        if (!add) {
            this.selectedElements.clear();
        }
        if (!this.selectedElements.contains(element)) {
            this.selectedElements.add(element);
        }
    }

    public static enum Page {
        MODEL,
        MATERIALS,
        PARTICLES,
        SOUNDS,
        EFFECTS,
        SETTINGS,
        SPRITES;

    }

    final class DraggingContext {
        private final FurnitureData.Element element;
        private class_2350 direction;
        private boolean autoDirectionLock;
        private final double x;
        private final double y;
        private final boolean resize;
        private final Map<FurnitureData.Element, Vector3f> originalFrom = new HashMap<FurnitureData.Element, Vector3f>();
        private final Map<FurnitureData.Element, Vector3f> originalTo = new HashMap<FurnitureData.Element, Vector3f>();
        private final boolean isFlat;

        DraggingContext(FurnitureData.Element element, class_2350 direction, double x, double y, boolean resize) {
            this.element = element;
            this.direction = direction;
            this.x = x;
            this.y = y;
            this.resize = resize;
            for (FurnitureData.Element e : ArtisansWorkstationEditorScreen.this.selectedElements) {
                this.originalFrom.put(e, new Vector3f((Vector3fc)e.from));
                this.originalTo.put(e, new Vector3f((Vector3fc)e.to));
            }
            this.isFlat = element.isFlat();
        }

        public float getOffset(double mouseX, double mouseY) {
            Vector3f normal = this.getNormal();
            Quaternionf q = new Quaternionf().rotateX(ArtisansWorkstationEditorScreen.this.camPitch).rotateY(ArtisansWorkstationEditorScreen.this.camYaw);
            q.transform(normal.mul(1.0f, -1.0f, 1.0f)).normalize();
            Vector3f screenNormal = new Vector3f(normal.x, normal.y, 0.0f).normalize();
            Vector3f drag = new Vector3f((float)(mouseX - this.x), (float)(mouseY - this.y), 0.0f);
            float proj = drag.dot((Vector3fc)screenNormal);
            if ((this.isFlat || class_437.method_25443()) && drag.lengthSquared() > 2.0f) {
                class_2350 bestDirection = this.direction;
                float bestDot = 0.0f;
                for (class_2350 value : class_2350.values()) {
                    if (this.autoDirectionLock && value != this.direction && value != this.direction.method_10153()) continue;
                    Vector3f directionNormal = this.element.getGlobalDirectionNormal(value);
                    q.transform(directionNormal.mul(1.0f, -1.0f, 1.0f)).normalize();
                    Vector3f directionScreenNormal = directionNormal.normalize();
                    float dot = directionScreenNormal.dot((Vector3fc)drag);
                    if (!(dot > bestDot)) continue;
                    bestDirection = value;
                    bestDot = dot;
                }
                this.direction = bestDirection;
                this.autoDirectionLock = true;
            }
            float viewDot = (float)Math.sqrt(1.0f - normal.z * normal.z);
            return proj / ArtisansWorkstationEditorScreen.this.camZoom * 16.0f / viewDot;
        }

        private Vector3f getNormal() {
            return this.element.getGlobalDirectionNormal(this.direction);
        }
    }

    public record HoverResult(FurnitureData.Element element, class_2350 direction, float depth) {
    }
}

