/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.data;

import java.util.HashMap;
import java.util.Map;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureRegistry;
import net.conczin.immersive_furniture.network.Network;
import net.conczin.immersive_furniture.network.s2c.FurnitureRegistryMessage;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ServerFurnitureRegistry {
    public static FurnitureRegistrySavedData getData(class_3218 level) {
        return (FurnitureRegistrySavedData)level.method_8503().method_30002().method_17983().method_17924(FurnitureRegistrySavedData::new, FurnitureRegistrySavedData::new, "immersive_furniture");
    }

    public static void increase(class_3218 level, FurnitureData data) {
        String hash = data.getHash();
        FurnitureRegistrySavedData registry = ServerFurnitureRegistry.getData(level);
        registry.usageCount.put(hash, registry.usageCount.getOrDefault(hash, 0) + 1);
        registry.method_80();
    }

    public static int registerIdentifier(class_3218 level, FurnitureData data, int from, int to) {
        String hash = data.getHash();
        FurnitureRegistrySavedData saveData = ServerFurnitureRegistry.getData(level);
        if (saveData.registry.hashToIdentifier.containsKey(hash)) {
            return saveData.registry.hashToIdentifier.get(hash);
        }
        int count = saveData.usageCount.getOrDefault(hash, 0);
        if (count < Config.getInstance().lowMemoryModeThreshold) {
            return -1;
        }
        for (int identifier = from; identifier <= to; ++identifier) {
            if (saveData.registry.identifierToHash.containsKey(identifier)) continue;
            saveData.registry.hashToIdentifier.put(hash, identifier);
            saveData.registry.identifierToHash.put(identifier, hash);
            saveData.method_80();
            FurnitureRegistryMessage message = new FurnitureRegistryMessage(Map.of(identifier, hash));
            for (class_3222 player : level.method_18456()) {
                Network.sendToPlayer(message, player);
            }
            return identifier;
        }
        return -1;
    }

    public static void syncWithPlayer(class_3222 player) {
        int chunkSize = 128;
        FurnitureRegistrySavedData savedData = ServerFurnitureRegistry.getData(player.method_51469());
        HashMap<Integer, String> subMap = new HashMap<Integer, String>();
        for (String hash : savedData.registry.hashToIdentifier.keySet()) {
            int identifier = savedData.registry.hashToIdentifier.get(hash);
            subMap.put(identifier, hash);
            if (subMap.size() < chunkSize) continue;
            FurnitureRegistryMessage message = new FurnitureRegistryMessage(subMap);
            Network.sendToPlayer(message, player);
            subMap.clear();
        }
        if (!subMap.isEmpty()) {
            FurnitureRegistryMessage message = new FurnitureRegistryMessage(subMap);
            Network.sendToPlayer(message, player);
        }
    }

    public static class FurnitureRegistrySavedData
    extends class_18 {
        final Map<String, Integer> usageCount = new HashMap<String, Integer>();
        final FurnitureRegistry registry = FurnitureRegistry.INSTANCE;

        public FurnitureRegistrySavedData() {
        }

        public FurnitureRegistrySavedData(class_2487 nbt) {
            class_2487 usageCountTag = nbt.method_10562("usageCount");
            usageCountTag.method_10541().forEach(key -> this.usageCount.put((String)key, usageCountTag.method_10550(key)));
            class_2487 hashToIdentifierTag = nbt.method_10562("hashToIdentifier");
            hashToIdentifierTag.method_10541().forEach(key -> {
                this.registry.hashToIdentifier.put((String)key, hashToIdentifierTag.method_10550(key));
                this.registry.identifierToHash.put(hashToIdentifierTag.method_10550(key), (String)key);
            });
        }

        public class_2487 method_75(class_2487 nbt) {
            class_2487 usageCountTag = new class_2487();
            this.usageCount.forEach((arg_0, arg_1) -> ((class_2487)usageCountTag).method_10569(arg_0, arg_1));
            nbt.method_10566("usageCount", (class_2520)usageCountTag);
            class_2487 hashToIdentifierTag = new class_2487();
            this.registry.hashToIdentifier.forEach((arg_0, arg_1) -> ((class_2487)hashToIdentifierTag).method_10569(arg_0, arg_1));
            nbt.method_10566("hashToIdentifier", (class_2520)hashToIdentifierTag);
            return nbt;
        }
    }
}

