/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.network.c2s;

import net.conczin.immersive_furniture.Sounds;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.item.FurnitureItem;
import net.conczin.immersive_furniture.item.Items;
import net.conczin.immersive_furniture.network.ImmersivePayload;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3419;

public record CraftRequest(FurnitureData data, boolean shift) implements ImmersivePayload
{
    private static long lastSoundTime = 0L;

    public CraftRequest(class_2540 b) {
        this(new FurnitureData(Utils.fromBytes(b.method_10795())), b.readBoolean());
    }

    @Override
    public void encode(class_2540 b) {
        class_2487 tag = this.data.toTag();
        b.method_10813(Utils.toBytes(tag));
        b.writeBoolean(this.shift);
    }

    @Override
    public void handle(class_1657 e) {
        if (!CraftRequest.isValid(this.data)) {
            return;
        }
        int cost = this.data.getCost();
        int available = this.getResources(e);
        if (e.method_7337()) {
            available = Integer.MAX_VALUE;
        }
        int amount = 1;
        if (this.shift) {
            amount = Math.min(available / cost, 64);
        }
        if (amount == 0) {
            return;
        }
        if (available < cost * amount) {
            e.method_7353((class_2561)class_2561.method_43471((String)"immersive_furniture.not_enough_material"), true);
        } else {
            if (!e.method_7337()) {
                this.useResources(e, amount * cost);
            }
            this.giveFurniture(e, this.data, amount);
            long time = System.currentTimeMillis();
            float volume = Math.min(1.0f, (float)Math.abs(lastSoundTime - time) / 1000.0f);
            if (volume > 0.05f) {
                lastSoundTime = time;
                e.method_37908().method_8396(null, e.method_23312(), Sounds.ASSEMBLE, class_3419.field_15245, (e.method_6051().method_43057() * 0.2f + 0.8f) * volume, e.method_6051().method_43057() * 0.5f + 0.75f);
            }
        }
    }

    private static boolean isValid(FurnitureData data) {
        return data != null;
    }

    private static boolean isValidItem(class_1799 stack) {
        return stack.method_7909() == Items.CRAFTING_MATERIAL;
    }

    private int getResources(class_1657 e) {
        int amount = 0;
        class_1661 inventory = e.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!CraftRequest.isValidItem(stack)) continue;
            amount += stack.method_7947();
        }
        return amount;
    }

    private void useResources(class_1657 e, int amount) {
        class_1661 inventory = e.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!CraftRequest.isValidItem(stack)) continue;
            if (stack.method_7947() >= amount) {
                stack.method_7934(amount);
                return;
            }
            amount -= stack.method_7947();
            inventory.method_5447(i, class_1799.field_8037);
        }
    }

    private void giveFurniture(class_1657 e, FurnitureData data, int count) {
        class_1799 stack = new class_1799((class_1935)Items.FURNITURE, count);
        FurnitureItem.setData(stack, data);
        if (!e.method_31548().method_7394(stack)) {
            e.method_7328(stack, false);
        }
    }
}

