/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.monorail;

import com.railwayteam.railways.content.bogey_menu.handler.BogeyMenuHandlerServer;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRShapes;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraphHelper;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackPropagator;
import com.simibubi.create.content.trains.track.TrackShape;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.Objects;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.AngleHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class MonorailTrackBlock
extends TrackBlock {
    public MonorailTrackBlock(class_4970.class_2251 properties, TrackMaterial material) {
        super(properties, material);
    }

    public class_2680 getBogeyAnchor(class_1922 world, class_2338 pos, class_2680 state) {
        Pair<BogeyStyle, BogeySizes.BogeySize> styleData;
        Object block = CRBlocks.MONO_BOGEY;
        if (BogeyMenuHandlerServer.getCurrentPlayer() != null && ((styleData = BogeyMenuHandlerServer.getStyle(BogeyMenuHandlerServer.getCurrentPlayer())).getFirst() == CRBogeyStyles.INVISIBLE || styleData.getFirst() == CRBogeyStyles.INVISIBLE_MONOBOGEY)) {
            block = CRBlocks.INVISIBLE_MONO_BOGEY;
        }
        return (class_2680)block.getDefaultState().method_11657((class_2769)class_2741.field_12529, (Comparable)(state.method_11654((class_2769)SHAPE) == TrackShape.XO ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051));
    }

    public class_265 method_9549(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return switch ((TrackShape)pState.method_11654((class_2769)SHAPE)) {
            case TrackShape.AE, TrackShape.AW, TrackShape.AN, TrackShape.AS -> class_259.method_1073();
            default -> CRShapes.MONORAIL_COLLISION;
        };
    }

    public class_265 method_9530(class_2680 state, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return this.getFullShape(state);
    }

    public class_265 method_9584(class_2680 state, class_1922 pLevel, class_2338 pPos) {
        return this.getFullShape(state);
    }

    private class_265 getFullShape(class_2680 state) {
        switch ((TrackShape)state.method_11654((class_2769)SHAPE)) {
            case AE: {
                return CRShapes.MONORAIL_TRACK_ASC.get(class_2350.field_11034);
            }
            case AW: {
                return CRShapes.MONORAIL_TRACK_ASC.get(class_2350.field_11039);
            }
            case AN: {
                return CRShapes.MONORAIL_TRACK_ASC.get(class_2350.field_11043);
            }
            case AS: {
                return CRShapes.MONORAIL_TRACK_ASC.get(class_2350.field_11035);
            }
            case CR_D: {
                return CRShapes.MONORAIL_TRACK_CROSS_DIAG;
            }
            case CR_NDX: {
                return CRShapes.MONORAIL_TRACK_CROSS_ORTHO_DIAG.get(class_2350.field_11035);
            }
            case CR_NDZ: {
                return CRShapes.MONORAIL_TRACK_CROSS_DIAG_ORTHO.get(class_2350.field_11035);
            }
            case CR_O: {
                return CRShapes.MONORAIL_TRACK_CROSS;
            }
            case CR_PDX: {
                return CRShapes.MONORAIL_TRACK_CROSS_DIAG_ORTHO.get(class_2350.field_11034);
            }
            case CR_PDZ: {
                return CRShapes.MONORAIL_TRACK_CROSS_ORTHO_DIAG.get(class_2350.field_11034);
            }
            case ND: {
                return CRShapes.MONORAIL_TRACK_DIAG.get(class_2350.field_11035);
            }
            case PD: {
                return CRShapes.MONORAIL_TRACK_DIAG.get(class_2350.field_11034);
            }
            case XO: {
                return CRShapes.MONORAIL_TRACK_ORTHO.get(class_2350.field_11034);
            }
            case ZO: {
                return CRShapes.MONORAIL_TRACK_ORTHO.get(class_2350.field_11035);
            }
            case TE: {
                return CRShapes.MONORAIL_TRACK_ORTHO_LONG.get(class_2350.field_11034);
            }
            case TW: {
                return CRShapes.MONORAIL_TRACK_ORTHO_LONG.get(class_2350.field_11039);
            }
            case TS: {
                return CRShapes.MONORAIL_TRACK_ORTHO_LONG.get(class_2350.field_11035);
            }
            case TN: {
                return CRShapes.MONORAIL_TRACK_ORTHO_LONG.get(class_2350.field_11043);
            }
        }
        return CRShapes.MONORAIL_TRACK_FALLBACK;
    }

    @Environment(value=EnvType.CLIENT)
    public PartialModel prepareAssemblyOverlay(class_1922 world, class_2338 pos, class_2680 state, class_2350 direction, class_4587 ms) {
        ((PoseTransformStack)TransformStack.of((class_4587)ms).rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((class_2350)direction)), class_2350.field_11036)).translateY(0.875f);
        return CRBlockPartials.MONORAIL_TRACK_ASSEMBLING_OVERLAY;
    }

    public void method_9514(class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (!state.method_28498((class_2769)SHAPE)) {
            return;
        }
        TrackGraphLocation location = TrackGraphHelper.getGraphLocationAt((class_1937)level, (class_2338)pos, (class_2350.class_2352)class_2350.class_2352.field_11056, (class_243)((class_243)((TrackShape)state.method_11654((class_2769)SHAPE)).getAxes().get(0)));
        if (location == null) {
            return;
        }
        Couple nodes = location.edge.map(e -> location.graph.locateNode(e));
        if (nodes.either(Objects::isNull)) {
            return;
        }
        TrackEdge edge = location.graph.getConnection(nodes);
        if (edge == null) {
            return;
        }
        if (edge.getTrackMaterial() != this.getMaterial()) {
            TrackPropagator.onRailAdded((class_1936)level, (class_2338)pos, (class_2680)state);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1269 result = super.method_9534(state, world, pos, player, hand, hit);
        if (result.method_23665()) {
            return result;
        }
        if (!world.field_9236 && AllItems.BRASS_HAND.isIn(player.method_5998(hand))) {
            TrackPropagator.onRailAdded((class_1936)world, (class_2338)pos, (class_2680)state);
            return class_1269.field_5812;
        }
        return result;
    }
}

