/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.semaphore;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.distant_signals.IOverridableSignal;
import com.railwayteam.railways.content.semaphore.SemaphoreBlock;
import com.railwayteam.railways.multiloader.PlayerSelection;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRIcons;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.util.packet.OverridableSignalPacket;
import com.simibubi.create.content.trains.signal.SignalBlock;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.gui.AllIcons;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class SemaphoreBlockEntity
extends SmartBlockEntity
implements IOverridableSignal {
    private WeakReference<SignalBlockEntity> cachedSignalTE = new WeakReference<Object>(null);
    public SignalBlockEntity.SignalState signalState;
    public final LerpedFloat armPosition = LerpedFloat.linear().startWithValue(0.0);
    public boolean isValid = false;
    public boolean isDistantSignal = false;
    protected boolean cachedWasUpsideDown = false;
    private int overrideLastingTicks = -1;

    public SemaphoreBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    public boolean wasCachedSearchingUpsideDown() {
        return this.cachedWasUpsideDown;
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.cachedWasUpsideDown = tag.method_10577("CachedWasUpsideDown");
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10556("CachedWasUpsideDown", this.cachedWasUpsideDown);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        boolean target;
        super.tick();
        if (!this.field_11863.field_9236) {
            return;
        }
        if (this.overrideLastingTicks > 0) {
            boolean target2;
            --this.overrideLastingTicks;
            SignalBlockEntity signalBE = (SignalBlockEntity)this.cachedSignalTE.get();
            if (signalBE != null && !signalBE.method_11015()) {
                this.signalState = signalBE.getState();
            }
            this.isValid = this.signalState != SignalBlockEntity.SignalState.INVALID;
            boolean isActive = false;
            if (this.isValid) {
                isActive = this.signalState == SignalBlockEntity.SignalState.YELLOW && !this.isDistantSignal || this.signalState == SignalBlockEntity.SignalState.GREEN;
            }
            float currentTarget = this.armPosition.getChaseTarget();
            boolean bl = target2 = isActive;
            if ((float)target2 != currentTarget) {
                this.armPosition.setValue((double)currentTarget);
                this.armPosition.chase((double)target2, (double)0.05f, LerpedFloat.Chaser.LINEAR);
            }
            this.armPosition.tickChaser();
            return;
        }
        if (this.overrideLastingTicks == 0) {
            --this.overrideLastingTicks;
            this.cachedSignalTE.clear();
            this.signalState = null;
            this.updateSignalConnection();
        }
        SignalBlockEntity signalBlockEntity = (SignalBlockEntity)this.cachedSignalTE.get();
        boolean isActive = false;
        if (signalBlockEntity != null && !signalBlockEntity.method_11015() && this.isValid) {
            this.signalState = signalBlockEntity.getState();
            if (this.signalState == SignalBlockEntity.SignalState.INVALID) {
                this.isValid = false;
            } else {
                isActive = this.signalState == SignalBlockEntity.SignalState.YELLOW && !this.isDistantSignal || this.signalState == SignalBlockEntity.SignalState.GREEN;
            }
        }
        float currentTarget = this.armPosition.getChaseTarget();
        boolean bl = target = isActive;
        if ((float)target != currentTarget) {
            this.armPosition.setValue((double)currentTarget);
            this.armPosition.chase((double)target, (double)0.05f, LerpedFloat.Chaser.LINEAR);
        }
        this.armPosition.tickChaser();
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.overrideLastingTicks > 0) {
            return;
        }
        this.signalState = null;
        this.updateSignalConnection();
    }

    boolean updateSignalConnection() {
        if (this.updateSignalConnection(this.cachedWasUpsideDown)) {
            return true;
        }
        if (this.updateSignalConnection(!this.cachedWasUpsideDown)) {
            this.cachedWasUpsideDown = !this.cachedWasUpsideDown;
            return true;
        }
        return false;
    }

    boolean updateSignalConnection(boolean upsideDown) {
        this.isValid = false;
        this.isDistantSignal = false;
        class_2338 currentPos = upsideDown ? this.field_11867.method_10084() : this.field_11867.method_10074();
        int semaphoresBelow = 0;
        boolean constantOrder = (Boolean)this.method_11010().method_11654((class_2769)SemaphoreBlock.UPSIDE_DOWN) == false || (Boolean)CRConfigs.server().semaphores.flipYellowOrder.get() == false;
        block0: for (int i = 0; i < 16; ++i) {
            class_2680 blockState = this.field_11863.method_8320(currentPos);
            class_2586 blockEntity = this.field_11863.method_8321(currentPos);
            if (blockEntity instanceof SignalBlockEntity) {
                SignalBlockEntity signal = (SignalBlockEntity)blockEntity;
                this.signalState = signal.getState();
                this.cachedSignalTE = new WeakReference<SignalBlockEntity>(signal);
                this.isValid = true;
                SignalBlock.SignalType stateType = (SignalBlock.SignalType)blockState.method_11654((class_2769)SignalBlock.TYPE);
                if (semaphoresBelow == 0 == (upsideDown && constantOrder)) break;
                currentPos = upsideDown ? (constantOrder ? currentPos : this.field_11867).method_10074() : this.field_11867.method_10084();
                for (int j = i + 1; j < 16; ++j) {
                    SemaphoreBlockEntity semaphore;
                    blockState = this.field_11863.method_8320(currentPos);
                    blockEntity = this.field_11863.method_8321(currentPos);
                    if (blockEntity instanceof SemaphoreBlockEntity && (semaphore = (SemaphoreBlockEntity)blockEntity).wasCachedSearchingUpsideDown() == this.wasCachedSearchingUpsideDown()) {
                        this.isDistantSignal = true;
                        break block0;
                    }
                    if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break block0;
                    currentPos = upsideDown ? currentPos.method_10074() : currentPos.method_10084();
                }
                break;
            }
            if (!(blockEntity instanceof SemaphoreBlockEntity) ? !CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState) : ++semaphoresBelow > 1) break;
            currentPos = upsideDown ? currentPos.method_10084() : currentPos.method_10074();
        }
        return this.isValid;
    }

    @Override
    public void railways$refresh(@Nullable SignalBlockEntity signalBE, SignalBlockEntity.SignalState state, int ticks, boolean distantSignal) {
        if (this.field_11863 == null) {
            return;
        }
        this.cachedSignalTE = new WeakReference<SignalBlockEntity>(signalBE);
        this.signalState = state;
        this.overrideLastingTicks = ticks;
        this.isDistantSignal = distantSignal;
        if (!this.field_11863.field_9236) {
            CRPackets.PACKETS.sendTo(PlayerSelection.tracking((class_2586)this), (S2CPacket)new OverridableSignalPacket(this.method_11016(), signalBE == null ? null : signalBE.method_11016(), state, ticks, distantSignal));
        }
    }

    @Override
    public Optional<SignalBlockEntity.SignalState> railways$getOverriddenState() {
        if (this.overrideLastingTicks > 0 && this.signalState != null) {
            return Optional.of(this.signalState);
        }
        return Optional.empty();
    }

    public static enum SearchMode implements INamedIconOptions
    {
        SEARCH_DOWN(CRIcons.I_SEARCH_DOWN),
        SEARCH_UP(CRIcons.I_SEARCH_UP);

        private final String translationKey;
        private final AllIcons icon;

        private SearchMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "railways.semaphore.search_mode." + Lang.asId((String)this.name());
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public boolean isUpsideDown() {
            return this == SEARCH_UP;
        }

        public static SearchMode fromUpsideDown(boolean upsideDown) {
            return upsideDown ? SEARCH_UP : SEARCH_DOWN;
        }
    }

    private static class SemaphoreValueBoxTransform
    extends CenteredSideValueBoxTransform {
        public SemaphoreValueBoxTransform() {
            super((state, d) -> {
                if (d.method_10166().method_10178()) {
                    return false;
                }
                boolean flipped = (Boolean)state.method_11654((class_2769)SemaphoreBlock.FLIPPED);
                class_2350 facing = (class_2350)state.method_11654((class_2769)SemaphoreBlock.field_11177);
                return d == facing || facing.method_10160() == (flipped ? d.method_10153() : d);
            });
        }

        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)11.0);
        }
    }
}

